/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity;

import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.util.EntityUtils;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class SittingEntity
extends Entity {
    int maxLifeTime = 100;
    private BlockPos sittingpos = BlockPos.field_177992_a;

    public SittingEntity(EntityType<?> type, World worldIn) {
        super(type, worldIn);
        this.func_82142_c(true);
        this.field_98038_p = true;
        this.field_70145_X = true;
        this.func_189654_d(true);
    }

    public SittingEntity(EntityType<?> type, World worldIn, double x, double y, double z, int lifeTime) {
        super(type, worldIn);
        this.func_70107_b(x, y, z);
        this.func_82142_c(true);
        this.field_98038_p = true;
        this.field_70145_X = true;
        this.func_189654_d(true);
        this.maxLifeTime = lifeTime;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.func_184207_aI() || this.maxLifeTime-- < 0) {
            if (this.func_184188_bt().size() > 0) {
                this.func_184226_ay();
            }
            this.func_70106_y();
        }
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        passenger.field_213325_aI = passenger.field_213325_aI.func_220312_a(1.0f, 0.5f);
    }

    protected void func_184225_p(Entity passenger) {
        BlockPos spawn;
        super.func_184225_p(passenger);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (passenger instanceof LivingEntity) {
            EntitySize entitySize = passenger.field_213325_aI = ((LivingEntity)passenger).func_70631_g_() ? passenger.func_200600_R().func_220334_j().func_220313_a(0.5f) : passenger.func_200600_R().func_220334_j();
        }
        if ((spawn = EntityUtils.getSpawnPoint(this.field_70170_p, this.func_233580_cy_())) != null) {
            passenger.func_70012_b((double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o(), (double)spawn.func_177952_p() + 0.5, passenger.field_70177_z, passenger.field_70125_A);
        }
    }

    @NotNull
    public Vector3d func_230268_c_(@NotNull LivingEntity passenger) {
        BlockPos start = this.sittingpos == BlockPos.field_177992_a ? this.func_233580_cy_().func_177984_a() : this.sittingpos;
        BlockPos spawn = EntityUtils.getSpawnPoint(this.field_70170_p, start);
        if (spawn == null) {
            return super.func_230268_c_(passenger);
        }
        return new Vector3d((double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o() + 0.2, (double)spawn.func_177952_p() + 0.5);
    }

    public void setMaxLifeTime(int maxLifeTime) {
        this.maxLifeTime = maxLifeTime;
    }

    public void setSittingPos(BlockPos pos) {
        this.sittingpos = pos;
    }

    public static void sitDown(BlockPos pos, MobEntity entity, int maxLifeTime) {
        if (entity.func_184187_bx() != null) {
            return;
        }
        SittingEntity sittingEntity = (SittingEntity)ModEntities.SITTINGENTITY.func_200721_a(entity.field_70170_p);
        BlockState state = entity.field_70170_p.func_180495_p(pos);
        double minY = 1.0;
        List shapes = state.func_196952_d((IBlockReader)entity.field_70170_p, pos).func_197756_d();
        for (AxisAlignedBB box : shapes) {
            if (!(box.field_72337_e < minY)) continue;
            minY = box.field_72337_e;
        }
        if (shapes.isEmpty()) {
            minY = 0.0;
        }
        sittingEntity.func_70107_b((float)pos.func_177958_n() + 0.5f, (double)pos.func_177956_o() + minY - (double)(entity.func_213302_cg() / 2.0f), (float)pos.func_177952_p() + 0.5f);
        sittingEntity.setMaxLifeTime(maxLifeTime);
        sittingEntity.setSittingPos(pos);
        entity.field_70170_p.func_217376_c((Entity)sittingEntity);
        entity.func_184220_m((Entity)sittingEntity);
        entity.func_70661_as().func_75499_g();
    }
}

